--- ../cyrus-sasl-2.1.19.orig/plugins/sql.c	2004-06-30 21:31:11.000000000 +0200
+++ plugins/sql.c	2004-09-07 13:38:57.285556518 +0200
@@ -54,6 +54,7 @@
     const char *sql_insert;
     const char *sql_update;
     int sql_usessl;
+    int sql_verbose;
 } sql_settings_t;
 
 static const char * SQL_BLANK_STRING = "";
@@ -279,8 +280,9 @@
     }
     else if (status != PGRES_TUPLES_OK) {
 	/* error */
-	utils->log(NULL, SASL_LOG_DEBUG, "sql plugin: %s ",
-		   PQresStatus(status));
+	if (settings->sql_verbose)
+		utils->log(NULL, SASL_LOG_DEBUG, "sql plugin: %s ",
+			   PQresStatus(status));
 	PQclear(result);
 	return -1;
     }
@@ -401,7 +403,8 @@
 
     rc = sqlite_exec((sqlite*)db, cmd, sqlite_my_callback, (void*)&result, &zErrMsg);
     if (rc != SQLITE_OK && rc != SQLITE_ABORT) {
-	utils->log(NULL, SASL_LOG_DEBUG, "sql plugin: %s ", zErrMsg);
+    	if (settings->sql_verbose)
+			utils->log(NULL, SASL_LOG_DEBUG, "sql plugin: %s ", zErrMsg);
 	sqlite_freemem (zErrMsg);
 	return -1;
     }
@@ -592,7 +595,7 @@
 {
     sql_settings_t *settings;
     int r;
-    const char *usessl, *engine_name;
+    const char *usessl, *engine_name, *sql_verbose;
     const sql_engine_t *e;
     
     settings = (sql_settings_t *) glob_context;
@@ -674,6 +677,11 @@
     } else {
 	settings->sql_usessl = 0;
     }
+    
+    /* sql verbose */
+    r = utils->getopt(utils->getopt_context, "SQL", "sql_verbose", &sql_verbose, NULL);
+    if (r || !sql_verbose) sql_verbose = "no";
+    settings->sql_verbose = (*sql_verbose == '1' || *sql_verbose == 'y'  || *sql_verbose == 't' || (*sql_verbose == 'o' && sql_verbose[1] == 'n'));
 }
 
 static void *sql_connect(sql_settings_t *settings, const sasl_utils_t *utils)
@@ -687,7 +695,8 @@
      * it should probably save the connection but for 
      * now we will just disconnect everytime
      */
-    utils->log(NULL, SASL_LOG_DEBUG,
+    if (settings->sql_verbose)
+    	utils->log(NULL, SASL_LOG_DEBUG,
 	       "sql plugin try and connect to a host\n");
     
     /* create a working version of the hostnames */
@@ -703,10 +712,11 @@
 	    while (!isalnum(db_host[0])) db_host++;
 	}
 	
-	utils->log(NULL, SASL_LOG_DEBUG,
-		   "sql plugin trying to open db '%s' on host '%s'%s\n",
-		   settings->sql_database, cur_host,
-		   settings->sql_usessl ? " using SSL" : "");
+	if (settings->sql_verbose)
+		utils->log(NULL, SASL_LOG_DEBUG,
+			   "sql plugin trying to open db '%s' on host '%s'%s\n",
+			   settings->sql_database, cur_host,
+			   settings->sql_usessl ? " using SSL" : "");
 	
 	/* set the optional port */
 	if ((cur_port = strchr(cur_host, ':'))) *cur_port++ = '\0';
@@ -720,7 +730,7 @@
 	if (conn) break;
 	
 	utils->log(NULL, SASL_LOG_ERR,
-		   "sql plugin could not connect to host %s", cur_host);
+	   "sql plugin could not connect to host %s", cur_host);
 	
 	cur_host = db_host;
     }
@@ -757,7 +767,8 @@
     /* setup the settings */
     settings = (sql_settings_t *) glob_context;
     
-    sparams->utils->log(NULL, SASL_LOG_DEBUG,
+    if (settings->sql_verbose)
+	    sparams->utils->log(NULL, SASL_LOG_DEBUG,
 			"sql plugin Parse the username %s\n", user);
     
     user_buf = sparams->utils->malloc(ulen + 1);
@@ -828,14 +839,16 @@
 
 	if (!do_txn) {
 	    do_txn = 1;
-	    sparams->utils->log(NULL, SASL_LOG_DEBUG, "begin transaction");
+	    if (settings->sql_verbose)
+		    sparams->utils->log(NULL, SASL_LOG_DEBUG, "begin transaction");
 	    if (settings->sql_engine->sql_begin_txn(conn, sparams->utils)) {
-		sparams->utils->log(NULL, SASL_LOG_ERR, 
-				    "Unable to begin transaction\n");
+			sparams->utils->log(NULL, SASL_LOG_ERR, 
+			    "Unable to begin transaction\n");
 	    }
 	}
-    
-	sparams->utils->log(NULL, SASL_LOG_DEBUG,
+
+	if (settings->sql_verbose)    
+		sparams->utils->log(NULL, SASL_LOG_DEBUG,
 			    "sql plugin create statement from %s %s %s\n",
 			    realname, escap_userid, escap_realm);
 	
@@ -845,7 +858,8 @@
 				     escap_realm, NULL,
 				     sparams->utils);
 	
-	sparams->utils->log(NULL, SASL_LOG_DEBUG,
+	if (settings->sql_verbose)
+		sparams->utils->log(NULL, SASL_LOG_DEBUG,
 			    "sql plugin doing query %s\n", query);
 	
 	/* run the query */
@@ -859,7 +873,8 @@
     }
 
     if (do_txn) {
-	sparams->utils->log(NULL, SASL_LOG_DEBUG, "commit transaction");
+    	if (settings->sql_verbose)
+			sparams->utils->log(NULL, SASL_LOG_DEBUG, "commit transaction");
 	if (settings->sql_engine->sql_commit_txn(conn, sparams->utils)) {
 	    sparams->utils->log(NULL, SASL_LOG_ERR, 
 				"Unable to commit transaction\n");
@@ -906,7 +921,8 @@
     /* make sure our input is okay */
     if (!glob_context || !sparams || !user) return SASL_BADPARAM;
     
-    sparams->utils->log(NULL, SASL_LOG_DEBUG,
+    if (settings->sql_verbose)
+	    sparams->utils->log(NULL, SASL_LOG_DEBUG,
 			"sql plugin Parse the username %s\n", user);
     
     user_buf = sparams->utils->malloc(ulen + 1);
@@ -993,9 +1009,11 @@
 				     cur->values && cur->values[0] ?
 				     "<omitted>" : SQL_NULL_VALUE,
 				     sparams->utils);
-	    sparams->utils->log(NULL, SASL_LOG_DEBUG,
-				"sql plugin doing statement %s\n",
-				log_statement);
+		
+	    if (settings->sql_verbose)
+	    	sparams->utils->log(NULL, SASL_LOG_DEBUG,
+					"sql plugin doing statement %s\n",
+					log_statement);
 	    sparams->utils->free(log_statement);
 	}
 	
@@ -1042,7 +1060,8 @@
     
     if (!settings) return;
     
-    utils->log(NULL, SASL_LOG_DEBUG, "sql freeing memory\n");
+    if (settings->sql_verbose)
+	    utils->log(NULL, SASL_LOG_DEBUG, "sql freeing memory\n");
     
     utils->free(settings);
 }
@@ -1090,9 +1109,10 @@
 	return SASL_NOMECH;
     }
 
-    utils->log(NULL, SASL_LOG_DEBUG,
-	       "sql auxprop plugin using %s engine\n",
-	       settings->sql_engine->name);
+	if (settings->sql_verbose)
+	    utils->log(NULL, SASL_LOG_DEBUG,
+		       "sql auxprop plugin using %s engine\n",
+	    	   settings->sql_engine->name);
     
     sql_auxprop_plugin.glob_context = settings;
     
